<?php
// create_admin.php
require 'config.php';

$username = 'brafa';
$password = 'Brafa.6868'; // Desired admin password
$role = 'admin';

// Check if admin user already exists
$stmt = $pdo->prepare("SELECT * FROM users WHERE username = :username");
$stmt->execute([':username' => $username]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    echo "Admin user already exists. Updating password...\n";
    // Hash the new password
    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
    // Update the user's password and role
    $updateStmt = $pdo->prepare("UPDATE users SET password = :password, role = :role WHERE username = :username");
    $updateStmt->execute([
        ':password' => $hashed_password,
        ':role' => $role,
        ':username' => $username
    ]);
    echo "Admin password updated successfully.\n";
} else {
    echo "Creating new admin user...\n";
    // Hash the password
    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
    // Insert the new admin user
    $insertStmt = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (:username, :password, :role)");
    $insertStmt->execute([
        ':username' => $username,
        ':password' => $hashed_password,
        ':role' => $role
    ]);
    echo "Admin user created successfully.\n";
}
?>
